//=============================================================================
// LimeLantern
//=============================================================================
class Limelantern extends Flashlight;

#exec obj load file=..\Textures\PlayrShp.utx package=PlayrShp
#exec obj load file=..\Textures\FireEng.utx package=FireEng
#exec obj load file=..\Textures\Starship.utx package=Starship


#exec mesh import mesh=Limelantern anivfile=Models\Limelantern_a.3d datafile=Models\Limelantern_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=Limelantern x=0 y=0 z=0
#exec mesh sequence mesh=Limelantern seq=All startframe=0 numframes=1

#exec meshmap new meshmap=Limelantern mesh=Limelantern
#exec meshmap scale meshmap=Limelantern x=0.08445 y=0.08445 z=0.16890


var FlashLightBeam s;
var float TimeChange;
var Vector HitNormal,HitLocation,EndTrace,StartTrace,X,Y,Z,NewHitLocation;

state Activated
{
    function endstate()
    {
        if (s!=None) s.Destroy();
        bActive = false;        
    }
    
    function Tick( float DeltaTime )
    {
        TimeChange += DeltaTime*10;
        if (TimeChange > 1) 
        {
            if ( s == None )
            {
                UsedUp();
                return;
            }       
            Charge -= int(TimeChange);
            TimeChange = TimeChange - int(TimeChange);
        }
        
        if (s == None) Return;

        if ( Pawn(Owner) == None )
        {
            s.Destroy();
            UsedUp();
            return;     
        }
        if (Charge<80)
        {
            SetOwnerLightingFlicker();
        }
        if (Charge<-0) 
        {
            s.Destroy();
            Pawn(Owner).ClientMessage(ExpireMessage);       
            UsedUp();       
        }
        if (Charge==255)
        Pawn(Owner).ClientMessage("Lantern fuel is running out!!!");
        if (Charge<255) s.LightBrightness=byte(Charge);
    }

    function BeginState()
    {
        SetOwnerLighting();
        TimeChange = 0;
        Owner.PlaySound(ActivateSound);     
        s = Spawn(class'LimeLightBeam',Owner, '', HitLocation+HitNormal*40);
    }

Begin:
}

state DeActivated
{
Begin:
    s.Destroy();
    Owner.PlaySound(DeActivateSound);
}

function SetOwnerLighting()
{
    if ( Owner.bIsPawn && Pawn(Owner).bIsPlayer
        && (Pawn(Owner).PlayerReplicationInfo.HasFlag != None) ) 
        return;

    Owner.AmbientGlow = 254; 
    Owner.LightEffect=LE_NonIncidence;
    Owner.LightBrightness=255;
    Owner.LightHue=210;
    Owner.LightRadius=30;
    Owner.LightSaturation=200;
    Owner.LightType=LT_Steady;
}

function SetOwnerLightingFlicker()
{
    if ( Owner.bIsPawn && Pawn(Owner).bIsPlayer
        && (Pawn(Owner).PlayerReplicationInfo.HasFlag != None) ) 
        return;

    Owner.AmbientGlow = 254; 
    Owner.LightEffect=LE_NonIncidence;
    Owner.LightBrightness=200;
    Owner.LightHue=210;
    Owner.LightRadius=20;
    Owner.LightSaturation=200;
    Owner.LightType=LT_Flicker;
}

singular function UsedUp()
{
    Owner.AmbientGlow = Owner.Default.AmbientGlow;
    Owner.LightType = LT_None;
    Destroy();
}
defaultproperties
{
     DrawType=DT_Mesh
     ExpireMessage="Lantern fuel is out."
     bActivatable=True
     bDisplayableInv=True
     bCollideWhenPlacing=True
     bCollideActors=True
     bCollideWorld=True
     bBlockActors=True
     bBlockPlayers=True
     PickupMessage="You picked up the Lantern"
     RespawnTime=40.000000
     PickupViewMesh=Mesh'Limelantern'
     Charge=20000
     PickupSound=Sound'UnrealShare.Pickups.GenPickSnd'
     ActivateSound=Sound'UnrealShare.Pickups.FSHLITE1'
     DeActivateSound=Sound'LadderSounds.LadderSounds.lsChange1'
     Icon=Texture'UnrealShare.Icons.I_Flashlight'
     RemoteRole=ROLE_DumbProxy
     Mesh=Mesh'Limelantern'
     AmbientGlow=96
     bMeshCurvy=False
     CollisionRadius=11.54701
     CollisionHeight=21.61880
     LightBrightness=100
     LightHue=167
     LightSaturation=187
     LightRadius=30  
     LightCone=255
     MultiSkins(0)=Texture'PlayrShp.Deco.Slotted3'
     MultiSkins(1)=Texture'FireEng.Fire.JWFire1'
     MultiSkins(2)=Texture'Starship.Base.Yellow1'
}

